package examples.stateless;

import javax.ejb.EJB;
import javax.ejb.Remote;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.Stateless;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptors;
import javax.interceptor.InvocationContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import examples.stateless.interceptors.AuditorInterceptor;
import examples.stateless.interceptors.LoggerInterceptor;
import examples.stateless.interfaces.PricerInjection;
import examples.stateless.interfaces.PricerLookup;
import examples.stateless.interfaces.TaxRate;

@Stateless
@Interceptors({LoggerInterceptor.class,AuditorInterceptor.class})
@Remote({PricerInjection.class,PricerLookup.class})
public class PricerBean implements PricerInjection, PricerLookup {
	private TaxRate taxRate;
	
	@EJB
	private TaxRate taxRate2;
	
	public double getTaxLookup(double cost, String state) {
		double tax = -1;
		tax = cost * taxRate.getTaxRate(state);
		return tax;
	}
	
	public double getTaxInjection(double cost, String state) {
		double tax = -1;
		tax = cost * taxRate2.getTaxRate(state);
		return tax;
	}
	
	@PostConstruct
	public void postConstruct() {
		try {
			InitialContext ic = new InitialContext();
			taxRate = (TaxRate)ic.lookup(TaxRate.class.getName());
		} 
		catch (NamingException e) {
			// some kind of appropriate handling here
		}
	}
	
	@PreDestroy
	public void preDestroy() {
		taxRate = null;
	}
	
	@AroundInvoke
	public Object logger(InvocationContext inv) throws Exception {
		System.out.println("Intercepted call via internal method to: "+inv.getMethod().getName());
		Object[] params = inv.getParameters();
		for (int i=0;i<params.length;i++) {
			System.out.println("\tparam: "+params[i]);
		}
		return inv.proceed();
	}
}
